/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sw extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Saa za Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Saa za Wastani za Apia",
               "",
               "Saa za Mchana za Apia",
               "",
               "Saa za Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Saa za Wastani za Visiwa vya Cook",
               "",
               "Saa za Majira nusu ya joto za Visiwa Cook",
               "",
               "Saa za Visiwa vya Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Saa za Wastani ya Kuba",
               "CST",
               "Saa za Mchana za Kuba",
               "CDT",
               "Saa za Kuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Saa za Wastani za Fiji",
               "",
               "Saa za Majira ya joto za Fiji",
               "",
               "Saa za Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Saa za Wastani za Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Saa za Wastani za Hovd",
               "",
               "Saa za Majira ya joto za Hovd",
               "",
               "Saa za Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Saa za Wastani za Iran",
               "",
               "Saa za Mchana za Iran",
               "",
               "Saa za Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Saa za Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Saa za Wastani za Omsk",
               "",
               "Saa za Majira ya joto za Omsk",
               "",
               "Saa za Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Saa za Wastani za Peru",
               "",
               "Saa za Majira ya joto za Peru",
               "",
               "Saa za Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Saa za Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Saa za Kisiwa cha Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Saa za Wastani za Chile",
               "",
               "Saa za Majira ya joto za Chile",
               "",
               "Saa za Chile",
               "",
            };
        final String[] China = new String[] {
               "Saa za Wastani za Uchina",
               "CST",
               "Saa za Mchana za Uchina",
               "CDT",
               "Saa za Uchina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Saa za Visiwa vya Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Saa za Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Saa za Wastani za India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Saa za Wastani za Japani",
               "JST",
               "Saa za Mchana za Japan",
               "JDT",
               "Saa za Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Saa za Wastani za Korea",
               "KST",
               "Saa za Mchana za Korea",
               "KST",
               "Saa za Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Saa za Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Saa za Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Saa za Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Saa za Wastani za Samoa",
               "SST",
               "Saa za Majira ya joto za Samoa",
               "SST",
               "Saa za Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Saa za Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Saa za Wastani za Tonga",
               "",
               "Saa za Majira ya joto za Tonga",
               "",
               "Saa za Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Saa za Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Saa za Wastani za Alaska",
               "AKST",
               "Saa za Mchana za Alaska",
               "AKDT",
               "Saa za Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Saa za Wastani za Amazon",
               "",
               "Saa za Majira ya joto za Amazon",
               "",
               "Saa za Amazon",
               "",
            };
        final String[] Anadyr = new String[] {
               "Saa za Wastani za Anadyr",
               "",
               "Saa za Kiangazi za Anadyr",
               "",
               "Saa za Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Saa za Wastani za Azores",
               "",
               "Saa za Majira ya joto za Azores",
               "",
               "Saa za Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Saa za Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Saa za Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Saa za Wastani za Kisiwa cha Easter",
               "",
               "Saa za Majira ya joto za Kisiwa cha Easter",
               "",
               "Saa za Kisiwa cha Easter",
               "",
            };
        final String[] Guyana = new String[] {
               "Saa za Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Saa za Wastani za Israeli",
               "IST",
               "Saa za Mchana za Israeli",
               "IDT",
               "Saa za Israeli",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Saa za Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Saa za Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Saa za Wastani za Moscow",
               "MSK",
               "Saa za Majira ya joto za Moscow",
               "MSK",
               "Saa za Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Saa za Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Saa za Wastani za Samara",
               "",
               "Saa za Kiangazi za Samara",
               "",
               "Saa za Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Saa za Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Saa za Wastani za Taipei",
               "CST",
               "Saa za Mchana za Taipei",
               "CDT",
               "Saa za Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Saa za Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Saa za Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Saa za Wallis na Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Saa za Wastani za Uarabuni",
               "",
               "Saa za Mchana za Arabiani",
               "",
               "Saa za Uarabuni",
               "",
            };
        final String[] Armenia = new String[] {
               "Saa za Wastani za Armenia",
               "",
               "Saa za Majira ya joto za Armenia",
               "",
               "Saa za Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Saa za Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Saa za Wastani za Chatham",
               "",
               "Saa za Mchana za Chatham",
               "",
               "Saa za Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Mfumo wa kuratibu saa ulimwenguni",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Saa za Ekwado",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Saa za Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Saa za Wastani za Jojia",
               "",
               "Saa za Majira ya joto za Jojia",
               "",
               "Saa za Jojia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Saa za Wastani za Irkutsk",
               "",
               "Saa za Majira ya joto za Irkutsk",
               "",
               "Saa za Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Saa za Wastani za Magadan",
               "",
               "Saa za Majira ya joto za Magadan",
               "",
               "Saa za Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Saa za Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Saa za Wastani za Kisiwa cha Norfolk",
               "",
               "Saa za Majira ya joto za Kisiwa cha Norfolk",
               "",
               "Saa za Kisiwa cha Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Saa za Wastani za Fernando de Noronha",
               "",
               "Saa za Majira ya joto za Fernando de Noronha",
               "",
               "Saa za Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Saa za Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Saa za Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Saa za Visiwa vya Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Saa za Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Saa za Wastani za Urugwai",
               "",
               "Saa za Majira ya joto za Urugwai",
               "",
               "Saa za Urugwai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Saa za Wastani za Vanuatu",
               "",
               "Saa za Majira ya joto za Vanuatu",
               "",
               "Saa za Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Saa za Wastani za Yakutsk",
               "",
               "Saa za Majira ya joto za Yakutsk",
               "",
               "Saa za Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Saa za Wastani za Atlantiki",
               "AST",
               "Saa za Mchana za Atlantiki",
               "AST",
               "Saa za Atlantiki",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Saa za Wastani za Brasilia",
               "",
               "Saa za Majira ya joto za Brasilia",
               "",
               "Saa za Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Saa za Wastani za Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Saa za Wastani za Kolombia",
               "",
               "Saa za Majira ya joto za Kolombia",
               "",
               "Saa za Kolombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Saa za Wastani za Visiwa vya Falkland",
               "",
               "Saa za Majira ya joto za Visiwa vya Falkland",
               "",
               "Saa za Visiwa vya Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Saa za Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Saa za Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Saa za Wastani za Ulan Bator",
               "",
               "Saa za Majira ya joto za Ulan Bator",
               "",
               "Saa za Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Saa za Wastani za Pakistan",
               "PKT",
               "Saa za Majira ya joto za Pakistan",
               "PKST",
               "Saa za Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Saa za Wastani za Paragwai",
               "",
               "Saa za Majira ya joto za Paragwai",
               "",
               "Saa za Paragwai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Saa za Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Saa za Wastani za Sakhalin",
               "",
               "Saa za Majira ya joto za Sakhalin",
               "",
               "Saa za Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Saa za Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Saa za Wastani za Argentina",
               "",
               "Saa za Majira ya joto za Argentina",
               "",
               "Saa za Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Saa za Kisiwa cha Krismasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Saa za Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Saa za Wastani za Hong Kong",
               "HKT",
               "Saa za Majira ya joto za Hong Kong",
               "HKST",
               "Saa za Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Saa za Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Saa za Wastani za Petropavlovsk-Kamchatski",
               "",
               "Saa za Kiangazi za Petropavlovsk-Kamchatski",
               "",
               "Saa za Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Saa za Kyrgystan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Saa za Wastani za Lord Howe",
               "",
               "Saa za Mchana za Lord Howe",
               "",
               "Saa za Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Saa za Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Saa za Wastani za Morisi",
               "",
               "Saa za Majira ya joto za Morisi",
               "",
               "Saa za Morisi",
               "",
            };
        final String[] Singapore = new String[] {
               "Saa za Wastani za Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Saa za Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Saa za Wastani za Volgograd",
               "MSK",
               "Saa za Majira ya joto za Volgograd",
               "MSK",
               "Saa za Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Saa za Wastani za Azerbaijan",
               "",
               "Saa za Majira ya joto za Azerbaijan",
               "",
               "Saa za Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Saa za Wastani za Bangladesh",
               "",
               "Saa za Majira ya joto za Bangladesh",
               "",
               "Saa za Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Saa za Wastani za Cape Verde",
               "",
               "Saa za Majira ya joto za Cape Verde",
               "",
               "Saa za Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Saa za Timor Mashariki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Saa za Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Saa za Ushelisheli",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Saa za Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Saa za Wastani za Uzbekistan",
               "",
               "Saa za Majira ya joto za Uzbekistan",
               "",
               "Saa za Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Saa za Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Saa za Wastani za Krasnoyask",
               "",
               "Saa za Majira ya joto za Krasnoyarsk",
               "",
               "Saa za Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Saa za Wastani za New Zealand",
               "NZST",
               "Saa za Mchana za New Zealand",
               "NZDT",
               "Saa za New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Saa za Wastani za Novosibirsk",
               "",
               "Saa za Majira ya joto za Novosibirsk",
               "",
               "Saa za Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Saa za Wastani za Ufilipino",
               "PST",
               "Saa za Majira ya joto za Ufilipino",
               "PDT",
               "Saa za Ufilipino",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Saa za Wastani za Vladivostok",
               "",
               "Saa za Majira ya joto za Vladivostok",
               "",
               "Saa za Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Saa za Bahari Hindi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Saa za Visiwa vya Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Saa za Wastani za Newfoundland",
               "NST",
               "Saa za Mchana za Newfoundland",
               "NDT",
               "Saa za Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Saa za Wastani za Turkmenistan",
               "",
               "Saa za Majira ya joto za Turkmenistan",
               "",
               "Saa za Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Saa za Guiana ya Ufaransa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Saa za Wastani za New Caledonia",
               "",
               "Saa za Majira ya joto za New Caledonia",
               "",
               "Saa za New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Saa za Georgia Kusini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Saa za Wastani za Yekaterinburg",
               "",
               "Saa za Majira ya joto za Yekaterinburg",
               "",
               "Saa za Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Saa za Afrika ya Kati",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Saa za Afrika Mashariki",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Saa za Wastani za Afrika Magharibi",
               "WAT",
               "Saa za Majira ya joto za Afrika Magharibi",
               "WAT",
               "Saa za Afrika Magharibi",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Saa za Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Saa za Wastani za Ulaya ya Kati",
               "CET",
               "Saa za Majira ya joto za Ulaya ya Kati",
               "CEST",
               "Saa za Ulaya ya Kati",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Saa za Wastani za Mashariki mwa Ulaya",
               "EET",
               "Saa za Majira ya joto za Mashariki mwa Ulaya",
               "EEST",
               "Saa za Mashariki mwa Ulaya",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Saa za Wastani za Magharibi mwa Ulaya",
               "WET",
               "Saa za Majira ya joto za Magharibi mwa Ulaya",
               "WEST",
               "Saa za Magharibi mwa Ulaya",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Saa za wastani za pasifiki za Meksiko",
               "MST",
               "Saa za mchana za pasifiki za Meksiko",
               "MDT",
               "Saa za pasifiki za Meksiko",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Saa za Wastani za Afrika Kusini",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Saa za Wastani za Kati",
               "CST",
               "Saa za Mchana za Kati",
               "CDT",
               "Saa za Kati",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Saa za Wastani za Mashariki",
               "EST",
               "Saa za Mchana za Mashariki",
               "EST",
               "Saa za Mashariki",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Saa za Wastani za Pasifiki",
               "PST",
               "Saa za Mchana za Pasifiki",
               "PDT",
               "Saa za Pasifiki",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Saa za Kusini mwa Ufaransa na Antaktiki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Saa za Visiwa vya Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Saa za Wastani za Hawaii-Aleutian",
               "HST",
               "Saa za Mchana za Hawaii-Aleutian",
               "HST",
               "Saa za Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Saa za Visiwa vya Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saa za Wastani ya Saint-Pierre na Miquelon",
               "",
               "Saa za Mchana za Saint-Pierre na Miquelon",
               "",
               "Saa za Saint-Pierre na Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Saa za Wastani za Mountain",
               "MST",
               "Saa za Mchana za Mountain",
               "MST",
               "Saa za Mountain",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Saa za Visiwa vya Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Saa za Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Saa za Wastani za Australia ya Kati",
               "ACST",
               "Saa za Mchana za Australia ya Kati",
               "ACDT",
               "Saa za Australia ya Kati",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Saa za Wastani za Mashariki mwa Australia",
               "AEST",
               "Saa za Mchana za Mashariki mwa Australia",
               "AEDT",
               "Saa za Australia Mashariki",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Saa za Wastani za Australia Magharibi",
               "AWST",
               "Saa za Mchana za Australia Magharibi",
               "AWDT",
               "Saa za Australia Magharibi",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Saa za Indonesia ya Kati",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Saa za Mashariki mwa Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Saa za Magharibi mwa Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Saa za Wastani za Magharibi ya Kati ya Australia",
               "",
               "Saa za Mchana za Magharibi ya Kati ya Australia",
               "",
               "Saa za Magharibi ya Kati ya Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Mfumo wa kuratibu saa ulimwenguni",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Ayalandi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Mfumo wa kuratibu saa ulimwenguni",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Mfumo wa kuratibu saa ulimwenguni",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Mfumo wa kuratibu saa ulimwenguni",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Mfumo wa kuratibu saa ulimwenguni",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Mfumo wa kuratibu saa ulimwenguni",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Ayalandi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Saa za Greenwich",
                    "GMT",
                    "Saa za Majira ya Joto za Uingereza",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Jiji Lisilojulikana" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Mexico_City", "Jiji la Mexico" },
            { "timezone.excity.America/Ciudad_Juarez", "Ciudad Juarez" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia Kusini" },
        };
        return data;
    }
}
