/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ceb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Oras sa Greenwich Mean",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Standard nga Oras sa Apia",
               "",
               "Daylight nga Oras sa Apia",
               "",
               "Oras sa Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Standard nga Oras sa Cook Islands",
               "",
               "Katungang Oras sa Ting-init sa Cook Islands",
               "",
               "Oras sa Cook Islands",
               "",
            };
        final String[] Cuba = new String[] {
               "Standard nga Oras sa Cuba",
               "CST",
               "Daylight nga Oras sa Cuba",
               "CDT",
               "Oras sa Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Standard nga Oras sa Fiji",
               "",
               "Oras sa Ting-init sa Fiji",
               "",
               "Oras sa Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Standard nga Oras sa Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Standard nga Oras sa Hovd",
               "",
               "Oras sa Ting-init sa Hovd",
               "",
               "Oras sa Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Standard nga Oras sa Iran",
               "",
               "Daylight nga Oras sa Iran",
               "",
               "Oras sa Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Oras sa Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Standard nga Oras sa Omsk",
               "",
               "Oras sa Ting-init sa Omsk",
               "",
               "Oras sa Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Standard nga Oras sa Peru",
               "",
               "Oras sa Ting-init sa Peru",
               "",
               "Oras sa Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Oras sa Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Oras sa Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Standard nga Oras sa Chile",
               "",
               "Oras sa Ting-init sa Chile",
               "",
               "Oras sa Chile",
               "",
            };
        final String[] China = new String[] {
               "Standard nga Oras sa China",
               "CST",
               "Daylight nga Oras sa China",
               "CDT",
               "Oras sa China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Oras sa Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Oras sa Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Standard nga Oras sa India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Standard nga Oras sa Japan",
               "JST",
               "Daylight nga Oras sa Japan",
               "JDT",
               "Oras sa Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Standard nga Oras sa Korea",
               "KST",
               "Daylight nga Oras sa Korea",
               "KST",
               "Oras sa Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Oras sa Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Oras sa Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Oras sa Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Standard nga Oras sa Samoa",
               "SST",
               "Daylight nga Oras sa Samoa",
               "SST",
               "Oras sa Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Oras sa Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Standard nga Oras sa Tonga",
               "",
               "Oras sa Ting-init sa Tonga",
               "",
               "Oras sa Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Oras sa Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Standard nga Oras sa Alaska",
               "AKST",
               "Daylight nga Oras sa Alaska",
               "AKDT",
               "Oras sa Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Standard nga Oras sa Amazon",
               "",
               "Oras sa Ting-init sa Amazon",
               "",
               "Oras sa Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Standard nga Oras sa Azores",
               "",
               "Oras sa Ting-init sa Azores",
               "",
               "Oras sa Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Oras sa Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Oras sa Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Standard nga Oras sa Easter Island",
               "",
               "Oras sa Ting-init sa Easter Island",
               "",
               "Oras sa Easter Island",
               "",
            };
        final String[] Guyana = new String[] {
               "Oras sa Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Standard nga Oras sa Israel",
               "IST",
               "Daylight nga Oras sa Israel",
               "IDT",
               "Oras sa Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Oras sa Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Oras sa Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Standard nga Oras sa Moscow",
               "MSK",
               "Oras sa Ting-init sa Moscow",
               "MSK",
               "Oras sa Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Oras sa Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Oras sa Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Standard nga Oras sa Taipei",
               "CST",
               "Daylight nga Oras sa Taipei",
               "CDT",
               "Oras sa Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Oras sa Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Oras sa Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Oras sa Wallis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Standard nga Oras sa Arabia",
               "",
               "Daylight nga Oras sa Arabia",
               "",
               "Oras sa Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Standard nga Oras sa Armenia",
               "",
               "Oras sa Ting-init sa Armenia",
               "",
               "Oras sa Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Oras sa Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Standard nga Oras sa Chatham",
               "",
               "Daylight nga Oras sa Chatham",
               "",
               "Oras sa Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Coordinated Universal Time",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Oras sa Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Oras sa Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Standard nga Oras sa Georgia",
               "",
               "Oras sa Ting-init sa Georgia",
               "",
               "Oras sa Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Standard nga Oras sa Irkutsk",
               "",
               "Oras sa Ting-init sa Irkutsk",
               "",
               "Oras sa Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Standard nga Oras sa Magadan",
               "",
               "Oras sa Ting-init sa Magadan",
               "",
               "Oras sa Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Oras sa Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Standard nga Oras sa Norfolk Island",
               "",
               "Daylight nga Oras sa Norfolk Island",
               "",
               "Oras sa Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Standard nga Oras sa Fernando de Noronha",
               "",
               "Oras sa Ting-init sa Fernando de Noronha",
               "",
               "Oras sa Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Oras sa Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Oras sa Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Oras sa Solomon Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Oras sa Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Standard nga Oras sa Uruguay",
               "",
               "Oras sa Ting-init sa Uruguay",
               "",
               "Oras sa Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Standard nga Oras sa Vanuatu",
               "",
               "Oras sa Ting-init sa Vanuatu",
               "",
               "Oras sa Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Standard nga Oras sa Yakutsk",
               "",
               "Oras sa Ting-init sa Yakutsk",
               "",
               "Oras sa Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Standard nga Oras sa Atlantic",
               "AST",
               "Daylight nga Oras sa Atlantic",
               "AST",
               "Oras sa Atlantic",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Standard nga Oras sa Brasilia",
               "",
               "Oras sa Ting-init sa Brasilia",
               "",
               "Oras sa Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Standard nga Oras sa Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Standard nga Oras sa Colombia",
               "",
               "Oras sa Ting-init sa Colombia",
               "",
               "Oras sa Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Standard nga Oras sa Falkland Islands",
               "",
               "Oras sa Ting-init sa Falkland Islands",
               "",
               "Oras sa Falkland Islands",
               "",
            };
        final String[] Malaysia = new String[] {
               "Oras sa Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Oras sa Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Standard nga Oras sa Ulaanbaatar",
               "",
               "Oras sa Ting-init sa Ulaanbaatar",
               "",
               "Oras sa Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Standard nga Oras sa Pakistan",
               "PKT",
               "Oras sa Ting-init sa Pakistan",
               "PKST",
               "Oras sa Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Standard nga Oras sa Paraguay",
               "",
               "Oras sa Ting-init sa Paraguay",
               "",
               "Oras sa Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Oras sa Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Standard nga Oras sa Sakhalin",
               "",
               "Oras sa Ting-init sa Sakhalin",
               "",
               "Oras sa Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Oras sa Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Standard nga Oras sa Argentina",
               "",
               "Oras sa Ting-init sa Argentina",
               "",
               "Oras sa Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Oras sa Christmas Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Oras sa Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Standard nga Oras sa Hong Kong",
               "HKT",
               "Oras sa Ting-init sa Hong Kong",
               "HKST",
               "Oras sa Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Oras sa Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Oras sa Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Standard nga Oras sa Lord Howe",
               "",
               "Daylight nga Oras sa Lord Howe",
               "",
               "Oras sa Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Oras sa Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Standard nga Oras sa Mauritius",
               "",
               "Oras sa Ting-init sa Mauritius",
               "",
               "Oras sa Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Standard nga Oras sa Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Oras sa Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Standard nga Oras sa Volgograd",
               "MSK",
               "Oras sa Ting-init sa Volgograd",
               "MSK",
               "Oras sa Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Standard nga Oras sa Azerbaijan",
               "",
               "Oras sa Ting-init sa Azerbaijan",
               "",
               "Oras sa Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Standard nga Oras sa Bangladesh",
               "",
               "Oras sa Ting-init sa Bangladesh",
               "",
               "Oras sa Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Standard nga Oras sa Cape Verde",
               "",
               "Oras sa Ting-init sa Cape Verde",
               "",
               "Oras sa Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oras sa East Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Oras sa Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Oras sa Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Oras sa Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Standard nga Oras sa Uzbekistan",
               "",
               "Oras sa Ting-init sa Uzbekistan",
               "",
               "Oras sa Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Oras sa Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Standard nga Oras sa Krasnoyarsk",
               "",
               "Oras sa Ting-init sa Krasnoyarsk",
               "",
               "Oras sa Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Standard nga Oras sa New Zealand",
               "NZST",
               "Daylight nga Oras sa New Zealand",
               "NZDT",
               "Oras sa New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Standard nga Oras sa Novosibirsk",
               "",
               "Oras sa Ting-init sa Novosibirsk",
               "",
               "Oras sa Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Standard nga Oras sa Pilipinas",
               "PST",
               "Oras sa Ting-init sa Pilipinas",
               "PDT",
               "Oras sa Pilipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Standard nga Oras sa Vladivostok",
               "",
               "Oras sa Ting-init sa Vladivostok",
               "",
               "Oras sa Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Oras sa Indian Ocean",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Oras sa Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Standard nga Oras sa Newfoundland",
               "NST",
               "Daylight nga Oras sa Newfoundland",
               "NDT",
               "Oras sa Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Standard nga Oras sa Turkmenistan",
               "",
               "Oras sa Ting-init sa Turkmenistan",
               "",
               "Oras sa Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Oras sa French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Standard nga Oras sa New Caledonia",
               "",
               "Oras sa Ting-init sa New Caledonia",
               "",
               "Oras sa New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Oras sa South Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Standard nga Oras sa Yekaterinburg",
               "",
               "Oras sa Ting-init sa Yekaterinburg",
               "",
               "Oras sa Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Oras sa Central Africa",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oras sa East Africa",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Standard nga Oras sa West Africa",
               "WAT",
               "Oras sa Ting-init sa West Africa",
               "WAT",
               "Oras sa West Africa",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Oras sa Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Standard nga Oras sa Central Europe",
               "CET",
               "Oras sa Ting-init sa Central Europe",
               "CEST",
               "Oras sa Central Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Standard nga Oras sa Eastern Europe",
               "EET",
               "Oras sa Ting-init sa Eastern Europe",
               "EEST",
               "Oras sa Eastern Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Standard nga Oras sa Western Europe",
               "WET",
               "Oras sa Ting-init sa Western Europe",
               "WEST",
               "Oras sa Western Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Standard nga Oras sa Mexican Pacific",
               "MST",
               "Daylight nga Oras sa Mexican Pacific",
               "MDT",
               "Oras sa Mexican Pacific",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Standard nga Oras sa South Africa",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Central Standard Time",
               "CST",
               "Central Daylight Time",
               "CDT",
               "Central Time",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern Standard Time",
               "EST",
               "Eastern Daylight Time",
               "EST",
               "Eastern Time",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Standard nga Oras sa Pasipiko",
               "PST",
               "Daylight nga Oras sa Pasipiko",
               "PDT",
               "Oras sa Pasipiko",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Oras sa French Southern ug Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Oras sa Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Standard nga Oras sa Hawaii-Aleutian",
               "HST",
               "Daylight nga Oras sa Hawaii-Aleutian",
               "HST",
               "Oras sa Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Oras sa Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Standard nga Oras sa St. Pierre & Miquelon",
               "",
               "Daylight nga Oras sa St. Pierre & Miquelon",
               "",
               "Oras sa St. Pierre & Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain Standard Time",
               "MST",
               "Mountain Daylight Time",
               "MST",
               "Mountain Time",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Oras sa Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Oras sa Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Standard nga Oras sa Central Australia",
               "ACST",
               "Daylight nga Oras sa Central Australia",
               "ACDT",
               "Oras sa Central Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Standard nga Oras sa Eastern Australia",
               "AEST",
               "Daylight nga Oras sa Eastern Australia",
               "AEDT",
               "Oras sa Eastern Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Standard nga Oras sa Western Australia",
               "AWST",
               "Daylight nga Oras sa Western Australia",
               "AWDT",
               "Oras sa Western Australia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Oras sa Central Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oras sa Eastern Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Oras sa Western Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Standard nga Oras sa Central Western Australia",
               "",
               "Daylight nga Oras sa Central Western Australia",
               "",
               "Oras sa Central Western Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "Irish Standard Time",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Coordinated Universal Time",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "Irish Standard Time",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "British Summer Time",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "Siyudad sa Ho Chi Minh" },
            { "timezone.excity.Etc/Unknown", "Wala Mailhing Lungsod" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
        };
        return data;
    }
}
