/*
 * Copyright (c) 2022, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package java.lang.classfile.attribute;

import java.lang.classfile.*;
import java.lang.classfile.AttributeMapper.AttributeStability;
import java.lang.reflect.AccessFlag;

import jdk.internal.classfile.impl.BoundAttribute;
import jdk.internal.classfile.impl.UnboundAttribute;

/**
 * Models the {@link Attributes#synthetic() Synthetic} attribute (JVMS {@jvms
 * 4.7.8}), which marks a class member as implementation-specific artifacts.
 * <p>
 * This attribute can appear on classes, methods, and fields, and permits
 * {@linkplain AttributeMapper#allowMultiple multiple instances} in a structure.
 * It has {@linkplain AttributeStability#STATELESS no data dependency}.
 * <p>
 * This attribute was introduced in the Java SE Platform version 1.1, major
 * version {@value ClassFile#JAVA_1_VERSION}.
 *
 * @apiNote
 * This attribute has been largely superseded by the {@link AccessFlag#SYNTHETIC
 * ACC_SYNTHETIC} modifier in newer {@code class} files.  See {@link
 * java.compiler/javax.lang.model.util.Elements.Origin} for a more in-depth
 * description about the differences between synthetic and implicit (mandated)
 * constructs generated by compilers.
 *
 * @see Attributes#synthetic()
 * @see AccessFlag#SYNTHETIC
 * @jvms 4.7.8 The {@code Synthetic} Attribute
 * @since 24
 */
@SuppressWarnings("doclint:reference")
public sealed interface SyntheticAttribute
        extends Attribute<SyntheticAttribute>,
                ClassElement, MethodElement, FieldElement
        permits BoundAttribute.BoundSyntheticAttribute, UnboundAttribute.UnboundSyntheticAttribute {

    /**
     * {@return a {@code Synthetic} attribute}
     */
    static SyntheticAttribute of() {
        return new UnboundAttribute.UnboundSyntheticAttribute();
    }
}
